import pandas as pd
import numpy as np
#Testing Scientific forecast

SF_Janina = pd.read_csv('C:/Data_waterapps/Data_Janina/SF_janina.csv')
SF_Nakpanzoo = pd.read_csv('C:/Users/joepb/OneDrive/Documenten/Wageningen - Uni/Master Thesis/Data_analysis/Data_2022/forecast_MB_Nakpanzoo.csv')
SF_Nakpanzoo_prob = pd.read_csv('C:/Users/joepb/OneDrive/Documenten/Wageningen - Uni/Master Thesis/Data_analysis/Data_2022/forecast_prob_MB_Nakpanzoo.csv')
del SF_Nakpanzoo_prob['Unnamed: 0']
del SF_Nakpanzoo_prob['forecastdatetime']
del SF_Nakpanzoo_prob['regionid']
del SF_Nakpanzoo_prob['variablecode']
del SF_Nakpanzoo_prob['datasourcecode']


SF_Janina['datetime'] = SF_Janina['timestamp']
del SF_Janina['timestamp']
SF_Janina['value_x'] = SF_Janina['meteoblue_tp']
del SF_Janina['meteoblue_tp']

n = 0
for n in range(len(SF_Janina)):
    if SF_Janina.loc[n,'value_x'] >= 20:
        SF_Janina.loc[n, 'cat_x'] = int(4)
    if SF_Janina.loc[n,'value_x'] <= 20 :
        SF_Janina.loc[n, 'cat_x'] = int(3)
    if SF_Janina.loc[n,'value_x'] <= 10 :
        SF_Janina.loc[n, 'cat_x'] = int(2)
    if SF_Janina.loc[n,'value_x'] <= 5:
        SF_Janina.loc[n, 'cat_x'] = int(1)
    if SF_Janina.loc[n,'value_x'] == 0:
        SF_Janina.loc[n, 'cat_x'] = int(0)

    if n == len(SF_Janina):
        break

SF_merge = SF_Nakpanzoo.merge(SF_Nakpanzoo_prob, left_on ='datetime', right_on = 'datetime' )
meteo_total = pd.concat([SF_Janina,SF_merge])
del meteo_total['Unnamed: 0']
del meteo_total['forecastdatetime']
del meteo_total['regionid']
del meteo_total['variablecode']
del meteo_total['datasourcecode']
meteo_total['datetime'] = pd.to_datetime(meteo_total['datetime'])
meteo_total = meteo_total.sort_values(by='datetime')
meteo_total.to_csv('C:/Users/joepb/PycharmProjects/data_storage/MB_prob_prec_total.csv',index = False)



indicator_complete = pd.read_csv('C:/Data_waterapps/Data_Janina/Indicators - Copy.csv',sep = ';' )
indicator_complete['Date'] = pd.to_datetime(indicator_complete['Date'], format = '%d-%m-%Y')
indicator_complete = indicator_complete.fillna(0)

#remove all Gbullung observations
Gbullung_obs = indicator_complete.loc[indicator_complete['Community'] == 'Gbullung']
index_names = indicator_complete[indicator_complete['Community'] == 'Gbullung'].index
indicator_complete.drop(index_names, inplace = True)
indicator_complete.reset_index(inplace=True)
del indicator_complete['index']



meteo_test = meteo_total.loc[meteo_total['datetime'].isin(indicator_complete['Date'])]
meteo_test.reset_index(inplace = True)
del meteo_test['index']
del meteo_test['value_y']
del meteo_test['cat_y']
del meteo_test['cat_x']
meteo_test.columns = ['datetime', 'value']
meteo_test.to_csv('C:/Users/joepb/OneDrive/Documenten/Wageningen - Uni/Master Thesis/Data_analysis/Data_2022/forecast_MB_Nakpanzoo_short.csv',index = False)

meteo_test.reset_index(inplace = True)
meteo_test_complete = meteo_test.merge(df_timetorain['sameday'], left_on = meteo_test['index'] , right_on = df_timetorain.index)


A = meteo_test_complete.loc[meteo_test_complete['cat_x'] > 0.0]
A = A.loc[A['sameday'] > 0.0]

B= meteo_test_complete.loc[meteo_test_complete['cat_x'] == 0]
B = B.loc[B['sameday'] > 0.0]

C = meteo_test_complete.loc[meteo_test_complete['cat_x'] == 0]
C = C.loc[C['sameday'] == 0]

D = meteo_test_complete.loc[meteo_test_complete['cat_x'] > 0.0]
D = D.loc[D['sameday'] == 0]

print(len(A),len(B),len(C),len(D))
HK_score = (len(A)*len(D) - len(C)*len(B) ) /( (len(A)+len(B)) *(len(C)+len(D)))
print(HK_score)


#Testing Farmer forecast

#testing over or under prediction
farmer_observations = pd.read_csv('C:/Users/joepb/PycharmProjects/data_storage/data_DROP_app/average_obs_NNY')
farmer_observations['datetime'] = pd.to_datetime(farmer_observations['datetime'])
farmer_observations = farmer_observations.set_index(farmer_observations['datetime'])
farmer_forecasts = pd.read_csv('C:/Users/joepb/PycharmProjects/data_storage/farmer_forecasts')
farmer_forecasts['datetime'] = pd.to_datetime(farmer_forecasts['datetime'])

comparison_data = pd.DataFrame(index=np.arange(1))
comparison_data[0] = 0
comparison_data[1] = 0
comparison_data[2] = 0

for i in range(len(farmer_forecasts)):
    try:
        if farmer_forecasts.loc[i,'value'] == int(farmer_observations.loc[farmer_forecasts.loc[i,'datetime'].strftime('%Y-%m-%d 00:00:00'),'value']):
            comparison_data[0] += 1
            print('True')
        elif farmer_forecasts.loc[i,'value'] > int(farmer_observations.loc[farmer_forecasts.loc[i,'datetime'].strftime('%Y-%m-%d 00:00:00'),'value']):
            comparison_data[1] += 1
            print('Too_much')
        elif farmer_forecasts.loc[i,'value'] < int(farmer_observations.loc[farmer_forecasts.loc[i,'datetime'].strftime('%Y-%m-%d 00:00:00'),'value']):
            comparison_data[2] += 1
            print('Too_little')
    except KeyError:
        continue


farmer_forecasts_0_1 = pd.DataFrame()
for i in farmer_forecasts.index:
    if farmer_forecasts.loc[i,'value'] > 0:
        farmer_forecasts_0_1.loc[i, 'datetime'] = farmer_forecasts.loc[i,'datetime']
        farmer_forecasts_0_1.loc[i, 'value'] = 1
    if farmer_forecasts.loc[i, 'value'] == 0:
        farmer_forecasts_0_1.loc[i, 'datetime'] = farmer_forecasts.loc[i,'datetime']
        farmer_forecasts_0_1.loc[i, 'value'] = 0

farmer_observations_0_1 = pd.DataFrame()
for i in farmer_observations.index:
    if farmer_observations.loc[i,'value'] > 0:
        farmer_observations_0_1.loc[i, 'datetime'] = farmer_observations.loc[i,'datetime']
        farmer_observations_0_1.loc[i, 'value'] = 1
    if farmer_observations.loc[i, 'value'] == 0:
        farmer_observations_0_1.loc[i, 'datetime'] = farmer_observations.loc[i,'datetime']
        farmer_observations_0_1.loc[i, 'value'] = 0

comparison_data_0_1 = pd.DataFrame(index=np.arange(1))
comparison_data_0_1[0] = 0
comparison_data_0_1[1] = 0
comparison_data_0_1[2] = 0


for i in range(len(farmer_forecasts_0_1)):
    try:
        if farmer_forecasts_0_1.loc[i,'value'] == int(farmer_observations_0_1.loc[farmer_forecasts_0_1.loc[i,'datetime'].strftime('%Y-%m-%d 00:00:00'),'value']):
            comparison_data_0_1[0] += 1
            print('True')
        elif farmer_forecasts_0_1.loc[i,'value'] > int(farmer_observations_0_1.loc[farmer_forecasts_0_1.loc[i,'datetime'].strftime('%Y-%m-%d 00:00:00'),'value']):
            comparison_data_0_1[1] += 1
            print('Too_much')
        elif farmer_forecasts_0_1.loc[i,'value'] < int(farmer_observations_0_1.loc[farmer_forecasts_0_1.loc[i,'datetime'].strftime('%Y-%m-%d 00:00:00'),'value']):
            comparison_data_0_1[2] += 1
            print('Too_little')
    except KeyError:
        continue

Rain_measurments_janina = pd.read_csv('C:/Users/joepb/PycharmProjects/data_storage/rain_janina.csv')
Rain_measurments_janina['datetime'] = pd.to_datetime(Rain_measurments_janina['datetime'])
Rain_measurments_janina = Rain_measurments_janina.set_index(Rain_measurments_janina['datetime'])
farmer_forecast_janina = pd.read_csv('C:/Users/joepb/PycharmProjects/data_storage/Farmer_forecast_janina.csv')
farmer_forecast_janina['datetime'] = pd.to_datetime(farmer_forecast_janina['datetime'])
farmer_forecast_janina.set_index('datetime', inplace=True)
farmer_forecast_janina = farmer_forecast_janina.rename(columns={'0':'Farmer_forecast'})

Janina_FF = pd.read_csv('C:/Data_waterapps/Data_Janina/Tamale_overall_farmer_forecast_janina.csv',sep = ';')
Janina_FF['datetime'] = pd.to_datetime(Janina_FF['datetime'], format = '%d-%m-%Y')
Janina_FF.fillna(0, inplace=True)
Janina_FF.set_index('datetime', inplace=True)
Janina_FF = Janina_FF.rename(columns=({'low':1,'medium':2,'high':3,'no_rain':0}))


comparison_data_janina = pd.DataFrame(index=np.arange(1))
comparison_data_janina[0] = 0
comparison_data_janina[1] = 0
comparison_data_janina[2] = 0

for i in Janina_FF.index:
   for j in Janina_FF:
        if j == int(Rain_measurments_janina.loc[i,'value']):
            comparison_data_janina[0] += (1 * Janina_FF.loc[i,j])
            print('True')
        elif j > int(Rain_measurments_janina.loc[i,'value']):
            comparison_data_janina[1] += (1 * Janina_FF.loc[i,j])
            print('Too_much')
        elif j < int(Rain_measurments_janina.loc[i,'value']):
            comparison_data_janina[2] += (1 * Janina_FF.loc[i,j])
            print('Too_little')

#for testing with only rain and no rain
for i in Janina_FF.index:
    Janina_FF.loc[i,1] = np.sum([int(Janina_FF.loc[i,1]),int(Janina_FF.loc[i,2]),int(Janina_FF.loc[i,3])])
del Janina_FF[2]
del Janina_FF[3]

Rain_measurments_janina_0_1 = pd.DataFrame()
for i in Rain_measurments_janina.index:
    if Rain_measurments_janina.loc[i,'value'] > 0:
        # Rain_measurments_janina_0_1.loc[i, 'datetime'] = farmer_forecast_janina.loc[i.strftime('%Y-%m-%d 00:00:00')]
        Rain_measurments_janina_0_1.loc[i, 'value'] = 1
    if Rain_measurments_janina.loc[i, 'value'] == 0:
        # Rain_measurments_janina_0_1.loc[i, 'datetime'] = farmer_forecast_janina.loc[i.strftime('%Y-%m-%d 00:00:00')]
        Rain_measurments_janina_0_1.loc[i, 'value'] = 0

for i in Janina_FF.index:
   for j in Janina_FF:
        if j == int(Rain_measurments_janina_0_1.loc[i,'value']):
            comparison_data_janina[0] += (1 * Janina_FF.loc[i,j])
            print('True')
        elif j > int(Rain_measurments_janina_0_1.loc[i,'value']):
            comparison_data_janina[1] += (1 * Janina_FF.loc[i,j])
            print('Too_much')
        elif j < int(Rain_measurments_janina_0_1.loc[i,'value']):
            comparison_data_janina[2] += (1 * Janina_FF.loc[i,j])
            print('Too_little')


farmer_forecast_janina_0_1 = pd.DataFrame()
for i in farmer_forecast_janina.index:
    if farmer_forecast_janina.loc[i,'Farmer_forecast'] > 0:
        # farmer_forecast_janina_0_1.loc[i, 'datetime'] = farmer_forecast_janina.loc[i.strftime('%Y-%m-%d 00:00:00')]
        farmer_forecast_janina_0_1.loc[i, 'value'] = 1
    if farmer_forecast_janina.loc[i, 'Farmer_forecast'] == 0:
        # farmer_forecast_janina_0_1.loc[i, 'datetime'] = farmer_forecast_janina.loc[i.strftime('%Y-%m-%d 00:00:00')]
        farmer_forecast_janina_0_1.loc[i, 'value'] = 0

farmer_observations_janina_0_1 = pd.DataFrame()
for i in Rain_measurments_janina.index:
    if Rain_measurments_janina.loc[i,'value'] > 0:
        farmer_observations_janina_0_1.loc[i, 'datetime'] = Rain_measurments_janina.loc[i,'datetime']
        farmer_observations_janina_0_1.loc[i, 'value'] = 1
    if Rain_measurments_janina.loc[i, 'value'] == 0:
        farmer_observations_janina_0_1.loc[i, 'datetime'] = Rain_measurments_janina.loc[i,'datetime']
        farmer_observations_janina_0_1.loc[i, 'value'] = 0




comparison_data_janina_0_1 = pd.DataFrame(index=np.arange(1))
comparison_data_janina_0_1[0] = 0
comparison_data_janina_0_1[1] = 0
comparison_data_janina_0_1[2] = 0


for i in farmer_forecast_janina_0_1.index:
    if farmer_forecast_janina_0_1.loc[i,'value'] == int(farmer_observations_janina_0_1.loc[i,'value']):
        comparison_data_janina_0_1[0] += 1
        print('True')
    elif farmer_forecast_janina_0_1.loc[i,'value'] > int(farmer_observations_janina_0_1.loc[i,'value']):
        comparison_data_janina_0_1[1] += 1
        print('Too_much')
    elif farmer_forecast_janina_0_1.loc[i,'value'] < int(farmer_observations_janina_0_1.loc[i,'value']):
        comparison_data_janina_0_1[2] += 1
        print('Too_little')



    # except KeyError:
    #     continue
